define(['InputRange'], function() {
	'use strict';

	describe('Input Range Directive', function () {
		var scope,
			isolateScope,
			elm,
			element,
			timeout;

		beforeEach(function () {
			module('angularTemplateApp');
			inject(function($templateCache) {
				$templateCache.put('src/ui-components/form/controls/simple/input-range/input-range_template.html', "<input></input>");
			});
		});

		describe('the directive', function () {
			beforeEach(function () {
				inject(function($rootScope, $compile, $timeout) {
					scope = $rootScope;
					timeout = $timeout;

					elm = "<form name='formName'><input-range form-name='formName' label='Range Label' name='rangeName' ng-model='scope.value' min='0' max='10' step='1' min-label='minLabel' max-label='maxLabel' is-sub-label='true' ng-disabled='false' ng-readonly='false' ng-required='false'></input-range></form>";
					element = $compile(elm)(scope);
					angular.element(document.body).append(element);
					scope.$digest();

					isolateScope = element.children(':first').isolateScope();
				});
			});

			it('should have isolateScope variables defined', function () {
				expect(isolateScope.label).toEqual("Range Label");
				expect(isolateScope.name).toEqual("rangeName");
				expect(isolateScope.step).toEqual("1");
				expect(isolateScope.min).toEqual("0");
				expect(isolateScope.max).toEqual("10");
				expect(isolateScope.minLabel).toEqual("minLabel");
				expect(isolateScope.maxLabel).toEqual("maxLabel");
				expect(isolateScope.inputModel).toEqual({ value : '0' });
				expect(isolateScope.rangeValues).toEqual([ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ]);
				expect(isolateScope.thumbDisplacement).toEqual({ left : '0%' });
				expect(isolateScope.liveLabel).toEqual({ inputValue : '0', labelReadable : false, valueReadable : false });
				expect(isolateScope.isSubLabel).toEqual('true');
				expect(isolateScope.ngDisabled).toEqual(false);
				expect(isolateScope.ngRequired).toEqual(false);
				expect(isolateScope.ngReadonly).toEqual(false);
				expect(isolateScope.formName).toEqual("formName");
			});

			it('should update the model and slider position', function() {
				isolateScope.inputModel.value = 5;
				isolateScope.updateNgModelAndSlider();

				timeout.flush();

				expect(isolateScope.ngModel).toEqual(5);
				expect(isolateScope.liveLabel).toEqual({ inputValue : '0', labelReadable : false, valueReadable : true });
				expect(isolateScope.thumbDisplacement.left).toMatch('[1-9]+[.]+[0-9]*[%]');
			});
		});
	});
});